//	ByteMunger.h

#ifndef _H_ByteMunger
#define _H_ByteMunger

#pragma options align = packed

//	reverse byte order word (short)
typedef struct {
	Byte		low;
	Byte		high;
} Rbo2Byte, RboShort;

typedef	struct {
	Byte	low;
	Byte	med;
	Byte	high;
} Rbo3Byte;

typedef	struct {
	Byte	low;
	Byte	med_low;
	Byte	med_high;
	Byte	high;
} Rbo4Byte;


#pragma options align = reset

#ifndef ulong
	typedef	unsigned long	ulong;
	typedef	unsigned short	ushort;
#endif

ushort		GetRboShort(RboShort rShort);
RboShort	SetRboShort(ushort value);

ulong		GetRbo3Bytes(Rbo3Byte r3);
Rbo3Byte	SetRbo3Bytes(ulong value);

ulong		GetRboLong(Rbo4Byte r4);
Rbo4Byte	SetRboLong(ulong value);

#endif